#include <FTPEx.au3>
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
; This var would need to be addded to FTPEx.au3. It is used to store the dll "handle" from the callback
; so that it can be freed later during _FTP_Close().
Global $__ghCallback_FTP = -1
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX


$server = 'ftp.mozilla.org'
$username = ''
$pass = ''

$Open = _FTP_Open('MyFTP Control')
$Callback = _FTP_SetStatusCallback($Open, '_FTPStatus')
$Conn = _FTP_Connect($Open, $server, $username, $pass, 0, 21, 1, 0, $Callback)
$Ftpc = __FTP_Close($Open)


;Example Callback Function
Func _FTPStatus($hInternet, $dwContent, $dwInternetStatus, $lpvStatusInformation, $dwStatusInformationLength)

    Switch $dwInternetStatus
        Case 50; $INTERNET_STATUS_CLOSING_CONNECTION
            ConsoleWrite('CLOSING_CONNECTION.....'& @CRLF)
        Case 51; $INTERNET_STATUS_CONNECTION_CLOSED
            ConsoleWrite('CONNECTION_CLOSED' & @CRLF)
        Case 20; $INTERNET_STATUS_CONNECTING_TO_SERVER
            ConsoleWrite('CONNECTING_TO_SERVER.....'& @CRLF)
        Case 21; $INTERNET_STATUS_CONNECTED_TO_SERVER
            ConsoleWrite('CONNECTED_TO_SERVER' & @CRLF)
        Case 42; $INTERNET_STATUS_CTL_RESPONSE_RECEIVED
            ConsoleWrite('CTL_RESPONSE_RECEIVED' & @CRLF)
        Case 120; $INTERNET_STATUS_INTERMEDIATE_RESPONSE
            ConsoleWrite('INTERMEDIATE_RESPONSE' & @CRLF)
        Case 43; $INTERNET_STATUS_PREFETCH
            ConsoleWrite('PREFETCH' & @CRLF)
        Case 110;$INTERNET_STATUS_REDIRECT
            ConsoleWrite('REDIRECT' & @CRLF)
        Case 100; $INTERNET_STATUS_REQUEST_COMPLETE
            ConsoleWrite('REQUEST_COMPLETE' & @CRLF)
        Case 60 ;$INTERNET_STATUS_HANDLE_CREATED
            ConsoleWrite('HANDLE_CREATED ' & @CRLF)
        Case 70 ;$INTERNET_STATUS_HANDLE_CLOSING
            ConsoleWrite('HANDLE_CLOSING' & @CRLF)
        Case 30; $INTERNET_STATUS_SENDING_REQUEST
            ConsoleWrite('SENDING_REQUEST.....' & @CRLF)
        Case 31; $INTERNET_STATUS_REQUEST_SENT
            Local $Size, $iBytesRead
            $Size = DllStructCreate('dword')
            _WinAPI_ReadProcessMemory(_WinAPI_GetCurrentProcess(), $lpvStatusInformation, DllStructGetPtr($Size), $dwStatusInformationLength, $iBytesRead)
            ConsoleWrite('REQUEST_SENT | Size = ' & DllStructGetData($Size, 1) & ' Bytes    Bytes read = ' & $iBytesRead  & @CRLF)
        Case 40; $INTERNET_STATUS_RECEIVING_RESPONSE
            ConsoleWrite('RECEIVING_RESPONSE.....'& @CRLF)
        Case 41;$INTERNET_STATUS_RESPONSE_RECEIVED
            Local $Size, $iBytesRead
            $Size = DllStructCreate('dword')
            _WinAPI_ReadProcessMemory(_WinAPI_GetCurrentProcess(), $lpvStatusInformation, DllStructGetPtr($Size), $dwStatusInformationLength, $iBytesRead)
            ConsoleWrite('REQUEST_SENT | Size = ' & DllStructGetData($Size, 1) & ' Bytes    Bytes read = ' & $iBytesRead  & @CRLF)
        Case 200; $INTERNET_STATUS_STATE_CHANGE
            ConsoleWrite('STATE_CHANGE' & @CRLF)
        Case 10; $INTERNET_STATUS_RESOLVING_NAME
            ConsoleWrite('RESOLVING_NAME.....'& @CRLF)
        Case 11; $INTERNET_STATUS_NAME_RESOLVED
            ConsoleWrite('NAME_RESOLVED' & @CRLF)
        Case Else
            ConsoleWrite($dwInternetStatus & @CRLF)
    EndSwitch
EndFunc   ;==>_InternetStatusCallback
#EndRegion


;FUNCTION# ====================================================================================================================
; Name...........: _FTP_SetStatusCallback
; Description ...: Registers callback function that WinINet functions can call as progress is made during an operation.
; Syntax.........: _InternetSetStatusCallback($l_InternetSession, $sFunctionName)
; Parameters ....: $l_FTPSession        - as returned by _FTP_Open().
;                  $sFunctionName       - Function Name
; Return values .: Success - Pointer to callback function
;                  Failure - 0
; Author ........: Beege
; Modified.......:
; Remarks .......: User Callback function MUST have five parameters. Ex: _Callback(parm1,parm2,parm3,parm4,parm5)
;				   Because callbacks are made during processing of the request, the application should spend little time in
;				   the callback function to avoid degrading data throughput on the network. For example, displaying a dialog
;				   box in a callback function can be such a lengthy operation that the server terminates the request.
; Related .......:
; Link ..........: @@MsdnLink@@ InternetSetStatusCallback
; Example .......: Yes
; ===============================================================================================================================
Func _FTP_SetStatusCallback($l_FTPSession, $s_FunctionName)
	If $__ghWinInet_FTP = -1 Then Return SetError(-2, 0, 0)

    Local $CallBack_Register = DllCallbackRegister($s_FunctionName, "none", "ptr;ptr;dword;ptr;dword")
	If @error Then Return SetError(-1, 0, 0)

    Local $ah_CallBackFunction = DllCall($__ghWinInet_FTP, "ptr", "InternetSetStatusCallback", "ptr", $l_FTPSession, "ulong_ptr", DllCallbackGetPtr($CallBack_Register))
	If @error Then Return SetError(-1, 0, 0)

	$__ghCallback_FTP = $ah_CallBackFunction[1]
    Return $ah_CallBackFunction[1]

EndFunc   ;==>_InternetSetStatusCallback

;A modified _FTP_Close() that releases Dllcallback if it has been registered. (Function taken from v3.3.1.3 beta)
Func __FTP_Close($l_InternetSession)
	If $__ghWinInet_FTP = -1 Then Return SetError(-2, 0, 0)
	Local $ai_InternetCloseHandle = DllCall($__ghWinInet_FTP, 'bool', 'InternetCloseHandle', 'handle', $l_InternetSession)
	If @error Or $ai_InternetCloseHandle[0] = 0 Then Return SetError(-1, _WinAPI_GetLastError(), 0)

	If $__ghCallback_FTP <> -1 Then DllCallbackFree($__ghCallback_FTP);<<<<< This is the only part that has been changed from the original.

	Return $ai_InternetCloseHandle[0]

EndFunc   ;==>_FTP_Close
